# Actuator assembly
There is one "actuator column" for each of the three axes of the OpenFlexure Microscope stage, to allow you to move the sample in X and Y, or focus the microscope by moving in Z.  It consists of a plastic gear that fits onto an M3 screw, which then pulls up on a brass nut.  Elastic bands pull down on the nut, tensioning the system.  The elastic band tightens up the mechanism, allowing us to move up and down smoothly.  Without the elastic band, you will only be able to move in one half of the microscope's range of travel, and the mechanism will be more wobbly.

# Requirements
All the parts you need for this step are in the picture below:

![Parts required for this step](./images/actuator_assembly_parts.jpg)

## Parts
*   3x [M3x25mm hexagon head screws](./parts/fixings/m3x25mm_hexagonhead_screw.md), stainless steel
*   3x [M3 brass nut](./parts/fixings/m3_brass_nut.md)
*   6x [M3 stainless steel washers](./parts/fixings/m3_washer.md)
*   3x [Viton O-ring, 30x2mm](./parts/fixings/viton_o_ring_30mm_inner_diameter_2mm_cross_section.md) (NB: get some spares!)
*   3 [Plastic gears](./parts/printed/gears.md)
*   1 set of [Microscope Feet](./parts/printed/feet.md) (NB there are different feet for X/Y axes and for the Z axis).
*   light grease (if available)

## Tools
*   [Nut and O ring insertion tools](./parts/printed_tools/actuator_assembly_tools.md)
*   Craft knife

# Assembly Instructions
There are three actuator columns on the microscope, for X, Y, and Z.  Follow these instructions for each column in turn.

## Step 1
We need to place a nut inside the actuator.  Insert it from the side, through the slot in the actuator column, and push it into place with the [nut insertion tool](./parts/printed_tools/actuator_assembly_tools.md).  Take care to insert the nut corner-first (i.e. with flat sides parallel to the tool), otherwise it will jam.

![putting the nut into the actuator column](./images/actuator_assembly_nut_insertion_1.jpg)
![The slot in the body now looks like this](./images/insert_nut_here.jpg)

## Step 2
Next, take a screw, and push it into a plastic gear, so that the head of the screw is embedded in the plastic.  Then, thread two washers onto the screw where it sticks out of the gear.  Put a very small blob of light oil or grease (if available) on the screw thread.  Put the screw into the hole at the top of the column, and screw it into the nut that is now inside the actuator.  The two washers should sit between the gear and the microscope body

![assembling the screw into the actuator column](./images/actuator_assembly_screw_in_1.jpg)
![The gear, with the screw and washers in place](./images/screw_gear_and_washers.jpg)

## Step 3
Turn the microscope over and, using the elastic band tool or a craft knife, snap the two thin plastic supports as shown if they are present.
![removing the ties that support the actuator column during printing](./images/actuator_assembly_snap_supports_1.jpg)

## Step 4
Hook one of the Viton bands over the elastic band tool, and pass the tool through the foot as shown.  You should end up with one loop of elastic band passing over each fork-shaped end of the insertion tool.  The flat side of the tool should be on the outside, so that the channels in either end face towards the centre of the foot.  Make sure you pick the right foot - the middle axis (Z) has a smaller foot.  The angle of the feet is different, if the foot doesn't line up with the outside of the microscope casing, you may be using the wrong one.

You may find it easier to put the band through the foot, then insert the tool and hook the band over either end - either way you should end up with the band, foot, and tool arranged as shown in the pictures. The band tool holder can be placed on the short end of the band insertion tool to hold it at the correct angle and increase the area to push against.

![The elastic band on the insertion tool, passed through the foot](./images/band_insertion_through_foot_1.jpg)
![Inserting the elastic bands](./images/band_insertion_through_foot_2.jpg)

## Step 5
Place the foot on the body, taking care that it's in the right place (the outer two actuators have sloping bottoms, but flat tops, the central Z axis has a sloping top and a flat bottom). You must also take care to put them on the right way round; the open part of the foot points towards the optics module in the centre of the microscope.

![Feet fitted into the microscope](./images/insert_feet.jpg)
 
Push the insertion tool in until the band clicks into place.  Use the nut insertion tool to hold the actuator in place while you do this.  It might help to unscrew the gear a bit (so you can see some of the screw thread between the body and the gear) and push down on the gear.  When you push the band in, it should click twice - once for each side.  If you don't manage to hook both sides on, you may need to completely remove the band and try again - a wooden skewer, or small flat-bladed screwdriver works well to unhook the band without damaging it.
 
What's happening here is that the elastic band is pushed over little hooks inside the actuator column, near the top, and the click is the band popping into place.  The band pulls down on the actuator, so after it's in place the gear should turn with a little more resistance - this is important for the microscope to work properly.

![Putting in the Viton o ring](./images/band_insertion_body_1.jpg)
![Putting in the Viton o ring](./images/band_insertion_body_2.jpg)
![The bands and feet in place in the microscope body](./images/insert_bands.jpg)

## Step 6
You should now have the band pulling both sides of the actuator down as shown.
![The Viton o ring, in place in the microscope's foot.](./images/band_insertion_finished_bottom.jpg)

## Step 7
Congratulations, you've assembled the actuator!  There are three to do, so you may now need to go back and make the next one.
