# Obtaining the non-printed parts
Make sure you have all the necessary parts and tools before you start.  The parts should all be listed in the bill of materials below, which is currently a work in progress (eventually it will be produced automatically, which should help it to stay accurate).  We recommend reading through all the instructions and checking that the quantities shown here add up correctly, until auto-generation is working.  Printed parts are described in the [next section](./0_printing.md).

## Fixing hardware:
*   3x [M3x25mm hexagon head screws](./parts/fixings/m3x25mm_hexagonhead_screw.md), stainless steel
*   3x [M3 brass nut](./parts/fixings/m3_brass_nut.md)
*   1x [M3 steel nut](./parts/fixings/m3_steel_nut.md) (using brass is also fine)
*   8x [M3 stainless steel washer](./parts/fixings/m3_washer.md)
*   3-14x [M3x8mm cap head screw](./parts/fixings/m3x8mm_caphead_screw.md) (some are optional, for sample clips and sample riser, but you will need at least three)
*   2-4x [M2x6mm cap head screws](./parts/fixings/m2x6mm_caphead_screw.md) 
*   6x [M4x6mm button head screws](./parts/fixings/m4x6mm_buttonhead_screw.md) (optional, for motors)
*   3x [Viton O-ring, 30x2mm](./parts/fixings/viton_o_ring_30mm_inner_diameter_2mm_cross_section.md) (NB: get some spares!)

## Electronic parts:
*   [5mm White LED](./parts/electronics/white_led.md)
*   [60 Ohm resistor](./parts/electronics/60_ohm_resistor.md)
*   [Stranded wire](./parts/electronics/stranded_wire.md)
*   [2-way JST header connector](./parts/electronics/2_way_jst_header.md) (so long as you have some way of lighting up the LED, it doesn't much matter)
*   [Raspbery Pi camera module](./parts/electronics/raspberry_pi_camera.md) (v2, though v1 works too)
*   [Raspberry Pi](./parts/electronics/raspberry_pi.md) (with associated power supply, keyboard, monitor, etc.)
*   3x [28BYJ-48 micro stepper motors](./parts/electronics/stepper_motors.md) (optional)
*   [Motor driver board](./parts/electronics/motor_driver.md) for the above (optional)

## Optical parts:
*   [13mm diameter, 5mm focal length plastic condenser lens](./parts/optics/condenser_lens.md) (optional, strongly recommended for high resolution optics)
*   [12.7mm diameter, 50mm focal length achromatic lens](./parts/optics/tube_lens.md) (for high resolution optics only)
*   [RMS threaded, finite-conjugates microscope objective](./parts/optics/objective.md) (for high resolution optics only)

## Tools:
*   2.5mm hex key
*   1.5mm hex key (to secure the camera using M2 screws)
*   tape (electrical tape or PTFE plumbers tape work nicely, though regular sticky tape is also fine)
*   sharp craft knife (for trimming tape and cleaning up the print)
*   3mm drill bit in hand chuck (if you printed the parts yourself and need to open out the holes)
*   needle nose pliers (optional, but useful - particularly good for cleaning up prints)

Don't forget the raspberry pi, camera module, and associated screen, power supply, SD card, keyboard, mouse, etc. (I have not listed these explicitly, but they're needed to run the Pi). Also, if you use the high resolution optics module or want to add motors, you will need additional parts.

While you're waiting for any parts you have ordered to arrive, why not try the next section on [printing the plastic parts](./0_printing.md).